package p11_tablice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class FunkcjeNaTablicach {

	static Integer max(int[] t) {
		if(t.length == 0) {
			return null;
		}
		int max = Integer.MIN_VALUE;
		for (int e : t) {
			if (e > max) {
				max = e;
			}
		}
		return max;
	}
	
	static Integer min(int[] t) {
		if(t.length == 0) {
			return null;
		}
		int min = Integer.MAX_VALUE;
		for (int e : t) {
			if (e < min) {
				min = e;
			}
		}
		return min;
	}
	
	static Integer min_v2(int[] t) {
		if(t.length == 0) {
			return null;
		}
		int min = t[0];
		for (int i = 1; i < t.length; i++) {
			if (t[i] < min) {
				min = t[i];
			}
		}
		return min;
	}
	
	static int roznicaMinMax_v1(int[] t) {
		// wersja "lepsza" jeśli kryterium oceny jest działanie, wydajność - bo tylko jedno przejście przez dane
		if(t.length == 0) {
			return 0;
		}
		int min = Integer.MAX_VALUE;
		int max = Integer.MIN_VALUE;
		for (int e : t) {
			if (e < min) {
				min = e;
			}
			if (e > max) {
				max = e;
			}
		}
		return max - min;
	}
	
	
	static int roznicaMinMax_v2(int[] t) {
		// wersja "lepsza" jeśli kryterium oceny jest styl, struktura kodu - bo korzystamy z już wcześniej napisanych rzeczy
		return t.length == 0 ? 0 : max(t) - min(t);
	}
	

	static void wypiszWieksze(int[] t, int x) {
		for (int e : t) {
			if (e > x) {
				System.out.print(e + ", ");
			}
		}
		System.out.println();
	}
	
	static Integer pierwszaWieksza(int[] t, int x) {
		for (int e : t) {
			if (e > x) {
				return e;
			}
		}
		return null;
	}
	
	static int sumaWiekszych(int[] t, int x) {
		int suma = 0;
		for (int e : t) {
			if (e > x) {
				suma += e;
			}
		}
		return suma;
	}
	
	static int ileWiekszych(int[] t, int x) {
		int ile = 0;
		for (int e : t) {
			if (e > x) {
				ile += 1;
			}
		}
		return ile;
	}
	

	static void wypiszPodzielne(int[] t, int x) {
		for (int e : t) {
			if (e % x == 0) {
				System.out.print(e + "; ");
			}
		}
		System.out.println();
	}
	
	static Integer pierwszaPodzielna(int[] t, int x) {
		for (int e : t) {
			if (e % x == 0) {
				return e;
			}
		}
		return null;
	}
	
	static int sumaPodzielnych(int[] t, int x) {
		int suma = 0;
		for (int e : t) {
			if (e % x == 0) {
				suma += e;
			}
		}
		return suma;
	}
	
	static int ilePodzielnych(int[] t, int x) {
		int ile = 0;
		for (int e : t) {
			if (e % x == 0) {
				ile++;
			}
		}
		return ile;
	}
	
	
	static Integer znajdzWspolny(int[] t1, int[] t2) {
		for (int e1 : t1) {
			for (int e2 : t2) {
				if (e1 == e2) {
					return e1;
				}
			}
		}
		return null;
	}
	
	static List<Integer> wszystkieWspolne(int[] t1, int[] t2) {
		List<Integer> lista = new ArrayList<>();
		for (int e1 : t1) {
			for (int e2 : t2) {
				if (e1 == e2) {
					lista.add(e1);
				}
			}
		}
		
		return lista;
	}
}
