package sprzedaz;

import java.io.File;
import java.io.FileNotFoundException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ObslugaCSV {
	
	public static List<Rekord> wczytaj(String sciezka) {
		return wczytaj(new File(sciezka));
	}

	public static List<Rekord> wczytaj(File plik) {
		List<Rekord> lista = new ArrayList<>();
		try(Scanner scanner = new Scanner(plik)) {
			scanner.nextLine();
			while(scanner.hasNextLine()) {
				String linia = scanner.nextLine();
				String[] t = linia.split(",", -1);
				Rekord rekord = new Rekord(LocalDate.parse(t[0]), t[1], t[2], t[3], t[4],
						new BigDecimal(t[5]), Integer.parseInt(t[6]));
				lista.add(rekord);
			}
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return lista;
	}

}
