package sprzedaz;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie3 {

	public static void main(String[] args) {
		List<Rekord> lista = ObslugaCSV.wczytaj("sprzedaz.csv");
		
		Map<String, BigDecimal> slownik = new TreeMap<>();
		for(Rekord rekord : lista) {
			slownik.merge(rekord.getMiasto(), rekord.getWartosc(), BigDecimal::add);
		}
		
		for(Map.Entry<String, BigDecimal> entry : slownik.entrySet()) {
			System.out.printf("%-10s → %12s%n", entry.getKey(), entry.getValue());
		}
	}

}
