package p07_polimorfizm;

import java.util.ArrayList;
import java.util.List;

public class Student extends Osoba {
	String kierunek;
	int rok;
	List<Integer> oceny = new ArrayList<>();
	
	public Student() {
		
	}
	
	// W Javie konstruktory nie są dziedziczone, ale narzędzia deweloperskie ułatwiają tworzenie takich konstruktorów w podklasie,
	// które przyjmują wszystkie wymagane parametry i przekzują do nadklasy za pomocą super();
	public Student(String imie, String nazwisko, int wiek, String kierunek, int rok) {
		super(imie, nazwisko, wiek);
		this.kierunek = kierunek;
		this.rok = rok;
	}

	// podklasa może
	// 1) nie zmieniać metod odziedziczonych z nadklasy
	// przykłady: jestPelnoletnia()

	// 2) dodać nowe metody, których nie było w nadklasie
	void dodajOcene(int ocena) {
		oceny.add(ocena);
	}
	
	double sredniaOcen() {
		double suma = 0;
		for(int ocena : oceny) {
			suma += ocena;
		}
		return suma / oceny.size();
	}
	
	// 3) nadpisać (override) metody, które były zdefiniowane w nadklasie
	//    czyli dla istniejących metoda podać inną treść
	@Override
	void przedstawSie() {
		System.out.println("Hej, tu " + imie + " " + nazwisko + ", studiuję kierunek " + kierunek + " na " + rok + " roku");
	}
	// Od Javy 5 przed definicją metody, która nadpisuje definicję z nadklasy, można umieścić adnotację @Override
	// Ważne: nawet bez tej adnotacji nadpisanie jest skuteczne. Adnotacja tylko:
	// - zwiększa czytelność kodu ("rzuca się w oczy")
	// - powoduje błąd kompilacji, gdyby okazało się, że jednak tutaj nie nadpisujemy metody, tylko definiujemy nową (np. literówka w nazwie, parametry innego typu)
	
	@Override
	public String toString() {
		return super.toString() + ", student " + rok + " roku kierunku " + kierunek ;
	}
	
}
