package p04_switch;

import javax.swing.JOptionPane;

/* W tej wersji piszemy własną funkcję (czyli w Javie "metodę statyczną"),
   która dokonuje tłumaczenia numeru na nazwę dnia tygodnia.
   To jest poprawne również w starszych wersjach Javy. */
public class DzienTygodnia5 {
	
	static String nazwaDniaTygodnia(int nr) {
		switch(nr) {
		case 1: return "poniedziałek";
		case 2: return "wtorek";
		case 3: return "środa";
		case 4: return "czwartek";
		case 5: return "piątek";
		case 6: return "sobota";
		case 7: return "niedziela";
		default: throw new IllegalArgumentException("Niepoprawny numer dnia: " + nr);
		}
	}

	public static void main(String[] args) {
		try {
			int numer = Integer.parseInt(JOptionPane.showInputDialog("Podaj nr dnia tygodnia"));
			String dzien = nazwaDniaTygodnia(numer);
			JOptionPane.showMessageDialog(null, "To jest " + dzien);
		} catch (Exception e) {
			JOptionPane.showMessageDialog(null, e, "Błąd", JOptionPane.ERROR_MESSAGE);
		}
		JOptionPane.showMessageDialog(null, "Koniec programu");
	}

}
