package emps;

import java.util.List;

public class F9_Kwantyfikatory {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// czy istnieje pracownik zarabiający 10 tys?
		if(emps.stream().anyMatch(emp -> emp.getSalary() == 10_000)) {
			System.out.println("A istnieje");
		} else {
			System.out.println("A nie istnieje");
		}

		// czy wszyscy pracownicy zarabiają co najmniej 3 tys?
		if(emps.stream().allMatch(emp -> emp.getSalary() >= 3000)) {
			System.out.println("B prawda");
		} else {
			System.out.println("B nieprawda");
		}

		// czy wszyscy programiści zarabiają co namjniej 3 tys?
		boolean b3 = emps.stream()
				.filter(emp -> "Programmer".equals(emp.getJobTitle()))
				.allMatch(emp -> emp.getSalary() >= 3000);
		if(b3) {
			System.out.println("C prawda");
		} else {
			System.out.println("C nieprawda");
		}
		
	}

}
