package waluty;

import static org.assertj.core.api.Assertions.*;

import java.math.BigDecimal;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class WalutaTestAssertJ {
	private Waluta dolar;
	private Waluta euro;
	private Waluta peso;

	@BeforeEach
	void setUp() {
		dolar = new Waluta("USD", "dolar", new BigDecimal("5.0000"));
		euro = new Waluta("EUR", "euro", new BigDecimal("3.0000"));
		peso = new Waluta("MXN", "peso", new BigDecimal("0.3333"));
	}

	@Test
	void testWaluta() {
		// asercje w stylu JUnit:
		// assertEquals("USD", dolar.getKod());
		
		// asersje w stylu AssertJ:
		assertThat(dolar.getCode()).isEqualTo("USD");
		
		// tylko prezentacja ciekawych asercji (akurat tutaj dla String)
		assertThat(dolar.getCode())
				.isNotNull()
				.hasSize(3)
				.isUpperCase()
				.startsWith("U")
				.endsWith("D");
	}

	@Test
	void testToString() {
		// assertEquals("USD (dolar): 5.0000", dolar.toString());
		assertThat(dolar.toString()).isEqualTo("USD (dolar): 5.0000");
		assertThat(euro.toString()).isEqualTo("EUR (euro): 3.0000");
	}
	
	@Test
	void testPrzeliczNaZlote() {
		BigDecimal sto = new BigDecimal("100.00");
		
		BigDecimal wynik = dolar.przeliczNaZlote(sto);
		assertThat(wynik).isEqualTo("500.00");
	}
	
	@Test
	void testPrzeliczNaZloteZaokr() {
		BigDecimal dwa = new BigDecimal("2.00");
		
		BigDecimal wynik = peso.przeliczNaZlote(dwa);
		assertThat(wynik).isEqualTo("0.67");
	}
	
	@Test
	void testPrzeliczNaWalute() {
		BigDecimal piescset = new BigDecimal("500.00");
		
		BigDecimal wynik = dolar.przeliczNaWalute(piescset);
		assertThat(wynik).isEqualTo("100.00");
	}
	
	@Test
	void testPrzeliczNaWaluteZaokr() {
		BigDecimal tysiac = new BigDecimal("2000.00");
		
		BigDecimal wynik = euro.przeliczNaWalute(tysiac);
		assertThat(wynik).isEqualTo("666.67");
	}

}
