package waluty;

import static org.junit.jupiter.api.Assertions.*;

import java.math.BigDecimal;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class WalutaTest {
	private Waluta dolar;

	@BeforeEach
	void setUp() {
		dolar = new Waluta("USD", "dolar", new BigDecimal("4.0000"));
	}

	@Test
	void testToString() {
		assertEquals("USD (dolar): 4.0000", dolar.toString());
	}
	
	@Test
	void testPrzeliczNaZlote() {
		BigDecimal kwotaUSD = new BigDecimal("1000.00");
		BigDecimal kwotaPLN = new BigDecimal("4000.00");
		BigDecimal wynik = dolar.przeliczNaZlote(kwotaUSD);
		assertEquals(kwotaPLN, wynik);
	}
	
	@Test
	void testPrzeliczNaZloteZaookraglanie() {
		Waluta waluta = new Waluta("ABC", "waluta ABC", new BigDecimal("3.3333"));
		
		BigDecimal kwota1 = new BigDecimal("2.00");
		BigDecimal oczekiwanywynik = new BigDecimal("6.67");
		BigDecimal wynik = waluta.przeliczNaZlote(kwota1);
		assertEquals(oczekiwanywynik, wynik);
	}
	
	@Test
	void testPrzeliczNaWalute() {
		BigDecimal kwotaPLN = new BigDecimal("4000.00");
		BigDecimal kwotaUSD = new BigDecimal("1000.00");
		BigDecimal wynik = dolar.przeliczNaWalute(kwotaPLN);
		assertEquals(kwotaUSD, wynik);
	}
	
	@Test
	void testPrzeliczNaWaluteZaokraglanie() {
		Waluta waluta = new Waluta("ABC", "waluta ABC", new BigDecimal("3.0000"));

		BigDecimal kwotaPLN = new BigDecimal("2000.00");
		BigDecimal oczekiwanyWynik = new BigDecimal("666.67");
		BigDecimal wynik = waluta.przeliczNaWalute(kwotaPLN);
		assertEquals(oczekiwanyWynik, wynik);
	}

}
