package waluty;

import static org.assertj.core.api.Assertions.*;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TabelaTestAssertJ {
	private static final String PRZYKLADOWY_NUMER = "123/A/NBP/2022";
	private static final LocalDate PRZYKLADOWA_DATA = LocalDate.of(2022, 9, 30);

	private TabelaWalut tabela;

	@BeforeEach
	void setUp() {
		tabela = new TabelaWalut(PRZYKLADOWY_NUMER, PRZYKLADOWA_DATA.toString());
	}

	@Test
	void testTabela() {
		assertThat(tabela.getNo()).isEqualTo(PRZYKLADOWY_NUMER);
		assertThat(tabela.getEffectiveDate()).isEqualTo(PRZYKLADOWA_DATA);
		assertThat(tabela.getRates()).isEmpty();
	}

	@Test
	void testToString() {
		assertThat(tabela).asString().isEqualTo("Tabela nr 123/A/NBP/2022 z dnia 2022-09-30, 0 walut");
	}
	
	@Test
	void testDodajWalute() {
		Waluta dolar = new Waluta("USD", "dolar", new BigDecimal("5.0000"));
		Waluta euro = new Waluta("EUR", "euro", new BigDecimal("3.0000"));
		
		tabela.addRate(dolar);
		tabela.addRate(euro);
		
		assertThat(tabela.getRates())
				.hasSize(2)
				.containsExactlyInAnyOrder(dolar, euro);
	}
	
	@Test
	void testWyszukaj() {
		Waluta dolar = new Waluta("USD", "dolar", new BigDecimal("5.0000"));
		Waluta euro = new Waluta("EUR", "euro", new BigDecimal("3.0000"));
		
		tabela.addRate(dolar);
		tabela.addRate(euro);
		
		Optional<Waluta> znaleziona = tabela.findByCode("EUR");
		assertThat(znaleziona)
				.isPresent()
				.contains(euro);
	}
	
	@Test
	void testCodes() {
		Waluta dolar = new Waluta("USD", "dolar", new BigDecimal("5.0000"));
		Waluta euro = new Waluta("EUR", "euro", new BigDecimal("3.0000"));
		tabela.addRate(dolar);
		tabela.addRate(euro);
		
		assertThat(tabela.codes())
			.hasSize(2)
			.containsExactlyInAnyOrder("USD", "EUR");
	}

}
