package apacz;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CzytajPlikCSV {

	public static void main(String[] args) {
		File plik = new File("emps.csv");
		
		CSVFormat format = CSVFormat.Builder.create()
				.setDelimiter(';')
				.setHeader().setSkipHeaderRecord(true)
				.build();
				
		try(CSVParser parser = CSVParser.parse(plik, Charset.forName("UTF-8"), format)) {
			for(CSVRecord record : parser) {
//				System.out.println(record);
//				System.out.printf("Pracownik %s %s (%s) zarabia %s\n",
//						record.get(1), record.get(2), record.get(3), record.get(4));
				System.out.printf("Pracownik %s %s (%s) zarabia %s\n",
						record.get("first_name"), record.get("last_name"), record.get("job_title"), record.get("salary"));
			}
		} catch (IOException e) {
			e.printStackTrace();
		};
	}

}
