package swing.zdarzenia;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Rozmowa1 {
    private static final Font FONT = new Font("Arial", Font.BOLD, 32);
    private static final Dimension odstep = new Dimension(0, 10);

    public static void main(String[] args) {
        JFrame okno = new JFrame("Rozmowa");
        okno.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        JPanel panel = new JPanel();
        okno.setContentPane(panel); // panel jest wnętrzem okna

        // panel.setBorder(BorderFactory.createLineBorder(Color.BLUE, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));

        LayoutManager layout = new BoxLayout(panel, BoxLayout.Y_AXIS);
        panel.setLayout(layout);

        JLabel pytanie = new JLabel("Jak masz na imię?");
        pytanie.setFont(FONT);
        panel.add(pytanie);

        panel.add(Box.createRigidArea(odstep));

        JTextField pole = new JTextField();
        pole.setFont(FONT);
        pole.setForeground(Color.MAGENTA);
        panel.add(pole);

        panel.add(Box.createRigidArea(odstep));

        JButton guzik = new JButton("OK");
        guzik.setFont(FONT);
        guzik.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        panel.add(guzik);

        panel.add(Box.createRigidArea(odstep));

        JLabel powitanie = new JLabel("Witaj");
        powitanie.setFont(FONT);
        powitanie.setForeground(Color.BLUE);
        panel.add(powitanie);

        panel.add(Box.createRigidArea(odstep));

        JButton guzik2 = new JButton("Niespodzianka");
        guzik2.setFont(FONT);
        guzik2.setForeground(Color.RED);
        guzik2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        panel.add(guzik2);

        panel.add(Box.createRigidArea(odstep));
        okno.pack();

        // Obsługa zdarzeń
        MojListener listener = new MojListener();
        guzik.addActionListener(listener);

        // W praktyce listenery definiuje się najczęściej bezpośrednio w tej samej klasie, co okno
        // jako "klasę anonimową" albo (od Java 8, dla niektórych interfejsów) jako "wyrażenie lambda".
        // Dzięki temu w kodzie obsługi zdarzeń możemy odwoływać się do komponentów okna.
        // klasa anonimowa
        guzik.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                String imie = pole.getText();
                powitanie.setText("Witaj " + imie);
                powitanie.setForeground(Color.BLUE);
            }
        });

        // wyrażenie lambda
        pole.addActionListener(evt -> {
            String imie = pole.getText();
            powitanie.setText("Cześć " + imie);
            powitanie.setForeground(Color.GREEN);
        });

        okno.setVisible(true);
        System.out.println("okno wyświetlone, koniec main");
    }

}
