package sprzedaz.wydajnosc;

import java.io.File;
import java.util.List;

import sprzedaz.MaszynaWczytujaca1;
import sprzedaz.Transakcja;

// A tu dla porównania wywołanie gotowej metody wczytaj w "MaszynaWczytujaca1", czyli w stylu, jaki na zajęciach stosowaliśmy dla klasy Employee.
public class WczytajSprzedaz9 {
	public static void main(String[] args) {
		Pomiary.wypiszPamiec();
		Opakowanie<List<Transakcja>> wynik = Opakowanie.empty();

		System.out.println("\nczytam");
		File plik = new File(WyczarujPliki.DUZY_PLIK);

		Pomiary.zmierzCzasDzalania(() -> {
			try {
				List<Transakcja> lista = MaszynaWczytujaca1.wczytaj(plik);
				wynik.set(lista); // aby GC nie usunął listy
				System.out.println("Wczytano " + lista.size());
			} catch (Exception e) {
				e.printStackTrace();
			}
		});
		Pomiary.wypiszPamiec();

		System.out.println("\ngc");
		System.gc();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
		}
		Pomiary.wypiszPamiec();
		System.out.println(wynik.get().size());
	}

}
