package sprzedaz.wydajnosc;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

import sprzedaz.Transakcja;

// Ta seria programów porównuje wydajność różnych technik wczytywania danych z pliku.
// Zwracamy uwagę na czas oraz zajętą pamięć.
// UWAGA. Aby te przykłady zadziałały, wcześniej trzeba uruchomić "WyczarujPliki" i utworzyć pliki z większą ilością (powtórzonych) danych.

// Wersja ze Scanner, split i LinkedList - działa najwolniej
public class WczytajSprzedaz1 {

	static List<Transakcja> wczytaj(File plik) throws IOException {
		List<Transakcja> lista = new LinkedList<>();
		try (Scanner sc = new Scanner(plik)) {
			sc.nextLine();
			while (sc.hasNextLine()) {
				String linia = sc.nextLine();
				String[] pola = linia.split(",");
				LocalDate data = LocalDate.parse(pola[0]);
				String miasto = pola[1];
				String sklep = pola[2];
				String kategoria = pola[3];
				String towar = pola[4];
				BigDecimal cena = new BigDecimal(pola[5]);
				int sztuk = Integer.parseInt(pola[6]);

				Transakcja transakcja = new Transakcja(data, miasto, sklep, kategoria, towar, cena, sztuk);
				lista.add(transakcja);
			}
		}
		return lista;
	}

	public static void main(String[] args) {
		Pomiary.wypiszPamiec();

		Opakowanie<List<Transakcja>> wynik = Opakowanie.empty();

		System.out.println("\nczytam");
		File plik = new File(WyczarujPliki.DUZY_PLIK);

		Pomiary.zmierzCzasDzalania(() -> {
			try {
				List<Transakcja> lista = wczytaj(plik);
				wynik.set(lista); // aby GC nie usunął listy
				System.out.println("Wczytano " + lista.size());
			} catch (IOException e) {
				e.printStackTrace();
			}
		});
		Pomiary.wypiszPamiec();

		System.out.println("\ngc");
		System.gc();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
		}
		Pomiary.wypiszPamiec();
		System.out.println(wynik.get().size());
	}

}
