package sprzedaz.wydajnosc;

import java.util.function.Function;

public class Pomiary {
	public static void zmierzCzasDzalania(Runnable runnable) {
		long p = System.currentTimeMillis();
		runnable.run();
		long k = System.currentTimeMillis();

		System.out.printf("t = %d\n", k - p);
	}

	public static void zmierzCzasDzalaniaRepeat(final Runnable runnable, final int repeat) {
		long p = System.currentTimeMillis();
		for(int i = 0; i < repeat; i++) {
			runnable.run();
		}
		long k = System.currentTimeMillis();

		System.out.printf("t = %d\n", k - p);
	}

	public static <T,R> void zmierzCzasDzalania(Function<T, R> funkcja, T arg) {
		long p = System.currentTimeMillis();
		Object res = funkcja.apply(arg);
		long k = System.currentTimeMillis();

		System.out.printf("t = %d\n", k - p);
	}
	
	public static void zmierzCzasDzalaniaIntString(Function<Integer, String> metoda, int n) {
		long p = System.currentTimeMillis();
		String str = metoda.apply(n);
		long k = System.currentTimeMillis();
		
		System.out.printf("n = %d, len = %d, t = %d\n", n, str.length(), k-p);
	}
	
	public static void wypiszPamiec() {
		Runtime runtime = Runtime.getRuntime();
		long used = (runtime.totalMemory() - runtime.freeMemory()) >> 20;
		long total = runtime.totalMemory() >> 20;
		
		System.out.printf("zajęta pamięć: %5d MB\n", used);
		System.out.printf("cała   pamięć: %5d MB\n", total);
	}
}
