package sprzedaz;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/* Operacja "funkcyjna" na słownikach dostępna od Java 8: merge
   Jest to operacja dokładnie implementująca ten schemat, który realizujemy w naszym zadaniu.

    slownik.merge(KLUCZ, WARTOŚĆ, FUNKCJA)
    Jeśli pod KLUCZem jeszcze niczego nie ma, to wpisywana jest WARTOŚĆ
    Jeśli pod KLUCZem jest już STARA_WARTOŚĆ, to uruchamiana jest FUNKCJA
    NOWA_WARTOŚĆ := FUNKCJA(STARA_WARTOŚĆ, WARTOŚĆ)
    np. jeśli funkcją jest operacja dodawania, to będzie tak:
    NOWA_WARTOŚĆ := STARA_WARTOŚĆ + WARTOŚĆ
  */
public class Grupowanie3 {
    public static void main(String[] args) {
        List<Transakcja> lista = MaszynaWczytujaca1.wczytaj();
        Map<String, BigDecimal> slownik = new TreeMap<>();

        for(Transakcja r : lista) {
            slownik.merge(r.miasto(), r.wartosc(), BigDecimal::add);
        }

        for (Map.Entry<String, BigDecimal> entry : slownik.entrySet()) {
            System.out.printf("%-10s : %12s%n", entry.getKey(), entry.getValue());
        }
    }
}
