package na_zywo.watki.konto_v2;

public class Konto {
    private final int numer;
    private String wlasciciel;
    private int saldo;

    public Konto(int numer, String wlasciciel, int saldo) {
        this.numer = numer;
        this.wlasciciel = wlasciciel;
        this.saldo = saldo;
    }

    public int getNumer() {
        return numer;
    }

    public String getWlasciciel() {
        return wlasciciel;
    }

    public int getSaldo() {
        return saldo;
    }

    public synchronized void wplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("kwota wpłaty nie jest dodatnia");
        }
        saldo += kwota;
        notify();
    }

    public synchronized void wyplataBezCzekania(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("kwota wypłaty nie jest dodatnia");
        }
        if(kwota > saldo) {
            throw new RuntimeException("Brak środków na koncie nr " + numer + ", potrzeba " + kwota + " a jest " + saldo);
        }
        saldo -= kwota;
    }

    public synchronized void wyplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("kwota wypłaty nie jest dodatnia");
        }
        try {
            while(kwota > saldo) {
                wait();
            }
            saldo -= kwota;
            notify();
        } catch (InterruptedException e) {
        }
    }

    @Override
    public String toString() {
        return "Konto{" +
                "numer=" + numer +
                ", wlasciciel='" + wlasciciel + '\'' +
                ", saldo=" + saldo +
                '}';
    }
}
