package na_zywo.lambdy;

import java.util.Arrays;

public class Przyklady {
    public static void main(String[] args) {
        // "klasa anonimowa" dostępna od Java 1.1
        FunkcjaLiczbowa a = new FunkcjaLiczbowa() {
            public double oblicz(double arg) {
                return 2*arg;
            }
        };
        System.out.println(a.oblicz(100));

        // Od Java 8 można używać "wyrażeń lambda"
        FunkcjaLiczbowa f = x -> x*x;
        System.out.println(f.oblicz(5));

        FunkcjaLiczbowa silnia = (double x) -> {
            double wynik = x;
            for(int i = 1; i < x; i++) {
                wynik *= i;
            }
            return wynik;
        };
        System.out.println(silnia.oblicz(5));

        double[] liczby = {1, 0, 5, 9, 4, 1.25, 0.333};
        System.out.println(Arrays.toString(liczby));
        Operacje.zmienTablice(liczby, f);
        System.out.println(Arrays.toString(liczby));
        // Operacje.zmienTablice(liczby, x -> Math.sqrt(x));
        Operacje.zmienTablice(liczby, Math::sqrt);
        System.out.println(Arrays.toString(liczby));
        Operacje.zmienTablice(liczby, x -> 10*x);
        System.out.println(Arrays.toString(liczby));
    }
}
