package na_zywo.lambdy;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PrzykladZNumerami {

    public static void main(String[] args) {
        List<String> telefony = List.of("123321123", "+48123123123", "431 666 777",
                "   0048987654321", "222.333-444", "123002244");
        System.out.println(telefony);

        List<String> listaWynikowa1 = telefony.stream()
                // .map(s -> s.replace(" ", ""))
                // .map(s -> s.replaceAll("[\\s\\-.]+", ""))
                .map(s -> s.replaceAll("[^\\d+]+", ""))
                .map(s -> s.replaceAll("^00", "+"))
                .map(s -> s.startsWith("+") ? s : "+48"+s)
                .toList();
        System.out.println(listaWynikowa1);

        Map<Boolean, List<String>> grupy = telefony.stream()
                //.map(String::strip)
                .map(s -> s.replaceAll("[\\s\\-.]+", ""))
                .map(s -> s.replaceAll("^00", "+"))
                .collect(Collectors.partitioningBy(s -> s.startsWith("+")));

        List<String> listaWynikowa2 =
                Stream.concat(grupy.get(true).stream(),
                    grupy.get(false).stream()
                        .map(s -> s.startsWith("+") ? s : "+48"+s))
                .toList();
        System.out.println(listaWynikowa2);
        System.out.println();


        Map<String, Integer> collect = telefony.stream()
                .map(s -> s.replaceAll("[^\\d+]+", ""))
                .collect(Collectors.toMap(nr -> nr, nr -> nr.length()));
        //.collect(Collectors.toCollection(TreeSet::new))

        System.out.println(collect);
    }
}
