package na_zywo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Double_vs_BigDecimal {
    static double[] wygeneruj1(int n) {
        double[] t = new double[n];
        double x = 0.01;
        double krok = 0.02;
        for(int i=0; i<n; i++) {
            t[i] = x;
            x += krok;
        }
        return t;
    }

    static double suma1(double[] t) {
        double suma = 0;
        for (double x : t) {
            suma += x;
        }
        return suma;
    }

    static List<Double> wygeneruj2(int n) {
        List<Double> t = new ArrayList<>(n);
        double x = 0.01;
        double krok = 0.02;
        for(int i=0; i<n; i++) {
            t.add(x);
            x += krok;
        }
        return t;
    }

    static Double suma2(List<Double> t) {
        Double suma = 0.0;
        for (var x : t) {
            suma += x;
        }
        return suma;
    }

    static List<BigDecimal> wygeneruj3(int n) {
        List<BigDecimal> t = new ArrayList<>(n);
        BigDecimal x = new BigDecimal("0.01");
        BigDecimal krok = new BigDecimal("0.02");
        for(int i=0; i<n; i++) {
            t.add(x);
            x = x.add(krok);
        }
        return t;
    }

    static BigDecimal suma3(List<BigDecimal> t) {
        BigDecimal suma = BigDecimal.ZERO;
        for (var x : t) {
            suma = suma.add(x);
        }
        return suma;
    }

    public static void main(String[] args) {
        int n = 100_000_000;
        long p, s, k;

        p = System.nanoTime();
        var t = wygeneruj1(n);
        s = System.nanoTime();
        var suma1 = suma1(t);
        k = System.nanoTime();
        System.out.printf("wynik: %s\n", suma1);
        System.out.printf("wynik: %.20f\n", suma1);
        System.out.printf("czas generowania %.3f\n", (s-p) * 1.e-9);
        System.out.printf("czas sumowania %.3f\n", (k-s) * 1.e-9);

        p = System.nanoTime();
        var ld = wygeneruj2(n);
        s = System.nanoTime();
        var suma2 = suma2(ld);
        k = System.nanoTime();
        System.out.printf("wynik: %s\n", suma2);
        System.out.printf("wynik: %.20f\n", suma2);
        System.out.printf("czas generowania %.3f\n", (s-p) * 1.e-9);
        System.out.printf("czas sumowania %.3f\n", (k-s) * 1.e-9);

        p = System.nanoTime();
        var ldec = wygeneruj3(n);
        s = System.nanoTime();
        var suma3 = suma3(ldec);
        k = System.nanoTime();
        System.out.printf("wynik: %s\n", suma3);
        System.out.printf("wynik: %.20f\n", suma3);
        System.out.printf("czas generowania %.3f\n", (s-p) * 1.e-9);
        System.out.printf("czas sumowania %.3f\n", (k-s) * 1.e-9);

    }

}
