package gotowe.p48_xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.util.Optional;

public class WypiszOsobyDom {
    public static void main(String[] args) {
        System.out.println("Startujemy");
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
//            dbf.setIgnoringComments(true);
//            dbf.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse("pliki/osoby.xml");
            System.out.println("Dokument wczytany " + doc);
            Element osoby = doc.getDocumentElement();
            System.out.println(osoby);
            // Jesteśmy w węźle <osoby>, a tak możemy przejść do jego "dzieci", czyli <osoba>
            // Sposób pierwszy: pętla po wszystkich dzieciach. Ale to obejmie również węzły tekstowe, komentarze itp.
            for(Node node = osoby.getFirstChild(); node != null; node = node.getNextSibling()) {
                System.out.println(node);
            }
            System.out.println("=========");
            
            // Jeśli jednak spodziewamy się elementów o określonej nazwie i chcemy od razu do nich przejść,
            // łatwiej będzie użyć drugiego sposobu:
            NodeList nodeSetOsoba = osoby.getElementsByTagName("osoba");
            for(int i = 0 ; i < nodeSetOsoba.getLength(); i++) {
                Element osoba = (Element)nodeSetOsoba.item(i);
                // String imie = osoba.getElementsByTagName("imie").item(0).getTextContent();
                // Aby w razie braku elementu imie uzyskać pusty string, można np tak wykorzystać klasę Optional
                String imie = Optional.ofNullable(osoba.getElementsByTagName("imie").item(0)).map(Node::getTextContent).orElse("");
                String nazwisko = Optional.ofNullable(osoba.getElementsByTagName("nazwisko").item(0)).map(Node::getTextContent).orElse("");
                String data = Optional.ofNullable(osoba.getElementsByTagName("dataUrodzenia").item(0)).map(Node::getTextContent).orElse("");
                String plec = osoba.getAttribute("plec");

                System.out.println("Osoba " + imie + " " + nazwisko + ", ur. " + data + " płeć: " + plec);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
