package gotowe.p48_xml;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLInputFactory;
import java.io.FileReader;

/* Wersja oparta o StAX StreamReader - w tym rozwiązaniu nie są tworzone obiekty Event dla każdego kroku,
   dzięki czemu jest to bardziej wydajne (gł pamięciowo), niż wersja poprzednia.
 */
public class Waluty5_StaxStream {

    public static void main(String[] args) {
        String plik = "pliki/waluty2023.xml";
        String waluta = "EUR";

        System.out.println("Startujemy");
        long t1 = System.nanoTime();
        try {
            XMLInputFactory xif = XMLInputFactory.newDefaultFactory();
            XMLStreamReader reader = xif.createXMLStreamReader(new FileReader(plik));

            double min = Double.MAX_VALUE, max = 0, sum = 0;
            int count = 0;

            while(reader.hasNext()) {
                int event = reader.next();
                if(event == XMLStreamReader.START_ELEMENT && reader.getName().getLocalPart().equals("Rate")) {
                    boolean uwzgledniajWalute = false;
                    while(true) {
                        reader.next();
                        if(reader.isStartElement() && reader.getName().getLocalPart().equals("Code")) {
                            if(waluta.equals(reader.getElementText())) {
                                uwzgledniajWalute = true;
                            }
                        } else
                        if(reader.isStartElement() && reader.getName().getLocalPart().equals("Mid")) {
                            if(uwzgledniajWalute) {
                                double mid = Double.parseDouble(reader.getElementText());
                                count++;
                                sum += mid;
                                if(mid < min) min = mid;
                                if(mid > max) max = mid;
                            }
                        } else
                        if(reader.isEndElement() && reader.getName().getLocalPart().equals("Rate")) {
                            break;
                        }
                    }
                }
            }

            long t3 = System.nanoTime();
            Runtime runtime = Runtime.getRuntime();

            System.out.printf("Czas łączny        : %.6f s%n", (t3-t1) * 1e-9);
            System.out.printf("Zajęta pamięć      : %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.gc();
            Thread.sleep(1000);
            System.out.printf("Zajęta pamięć po gc: %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.out.println("Count: " + count);
            if(count > 0) {
                System.out.println("Sum: " + sum);
                System.out.println("Avg: " + (sum / count));
                System.out.println("Min: " + min);
                System.out.println("Max: " + max);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
