package gotowe.p48_xml;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import java.io.FileReader;

/* Wersja oparta o StAX EventReader - dokument nie jest wczytywany do pamięci "na raz",
   ale w każdym kroku tworzony jest (zwykle b. mały) obiekt Event (różnego typu),
   co powoduje, że wydajność nie jest jeszcze optymalna,
   ale za to programuje się nieco wygodniej, niż w następnej wersji.
 */
public class Waluty4_StaxEvent {

    public static void main(String[] args) {
        String plik = "pliki/waluty2023.xml";
        String waluta = "EUR";

        System.out.println("Startujemy");
        long t1 = System.nanoTime();
        try {
            XMLInputFactory xif = XMLInputFactory.newDefaultFactory();
            XMLEventReader reader = xif.createXMLEventReader(new FileReader(plik));

            double min = Double.MAX_VALUE, max = 0, sum = 0;
            int count = 0;

            while(reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if(event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("Rate")) {
                    boolean uwzgledniajWalute = false;
                    while(true) {
                        XMLEvent event2 = reader.nextEvent();
                        if(event2.isStartElement() && event2.asStartElement().getName().getLocalPart().equals("Code")) {
                            if(waluta.equals(reader.getElementText())) {
                                uwzgledniajWalute = true;
                            }
                        } else
                        if(event2.isStartElement() && event2.asStartElement().getName().getLocalPart().equals("Mid")) {
                            if(uwzgledniajWalute) {
                                double mid = Double.parseDouble(reader.getElementText());
                                count++;
                                sum += mid;
                                if(mid < min) min = mid;
                                if(mid > max) max = mid;
                            }
                        } else
                        if(event2.isEndElement() && event2.asEndElement().getName().getLocalPart().equals("Rate")) {
                            break;
                        }
                    }
                }
            }

            long t3 = System.nanoTime();
            Runtime runtime = Runtime.getRuntime();

            System.out.printf("Czas łączny        : %.6f s%n", (t3-t1) * 1e-9);
            System.out.printf("Zajęta pamięć      : %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.gc();
            Thread.sleep(1000);
            System.out.printf("Zajęta pamięć po gc: %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.out.println("Count: " + count);
            if(count > 0) {
                System.out.println("Sum: " + sum);
                System.out.println("Avg: " + (sum / count));
                System.out.println("Min: " + min);
                System.out.println("Max: " + max);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
