package gotowe.p48_xml;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import java.io.File;
import java.io.FileInputStream;

public class Waluty3a_XPath_TylkoSuma {
    // W tej wersji staram się od razu jak najwięcej wyrazić w języku XPath, a jak najmiej pisać w Javie.

    public static void main(String[] args) {
        String plik = "pliki/waluty2023.xml";
        String waluta = "EUR";

        System.out.println("Startujemy");
        long t1 = System.nanoTime();
        try {
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            InputSource src = new InputSource(plik);

            long t2 = System.nanoTime();

            waluta = waluta.replace("'", "''"); // eskejpowanie dla bezpieczeństwa
            final String expr = "sum(/ArrayOfExchangeRatesTable/ExchangeRatesTable/Rates/Rate[Code='" + waluta + "']/Mid)";
            double sum = (Double)xpath.evaluate(expr, src, XPathConstants.NUMBER);

            long t3 = System.nanoTime();
            Runtime runtime = Runtime.getRuntime();

            System.out.printf("Czas czytania pliku: %.6f s%n", (t2-t1) * 1e-9);
            System.out.printf("Czas liczenia      : %.6f s%n", (t3-t2) * 1e-9);
            System.out.printf("Czas łączny        : %.6f s%n", (t3-t1) * 1e-9);
            System.out.printf("Zajęta pamięć      : %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.gc();
            Thread.sleep(1000);
            System.out.printf("Zajęta pamięć po gc: %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.out.println("Sum: " + sum);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
