package gotowe.p48_xml;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import java.io.File;

public class Waluty3_XPath {
    // W tej wersji staram się od razu jak najwięcej wyrazić w języku XPath, a jak najmiej pisać w Javie.

    public static void main(String[] args) {
        String plik = "pliki/waluty2023.xml";
        String waluta = "EUR";

        System.out.println("Startujemy");
        long t1 = System.nanoTime();
        try {
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            XPathExpression kropka = xpath.compile(".");
            InputSource src = new InputSource(plik);

            long t2 = System.nanoTime();

            double min = Double.MAX_VALUE, max = 0, sum = 0;

            waluta = waluta.replace("'", "''"); // eskejpowanie dla bezpieczeństwa
            final String expr = "/ArrayOfExchangeRatesTable/ExchangeRatesTable/Rates/Rate[Code='" + waluta + "']/Mid";
            NodeList mids = (NodeList) xpath.evaluate(expr, src, XPathConstants.NODESET);
            final int count = mids.getLength();
            for(int i = 0; i < count; i++) {
                double mid = (Double) kropka.evaluate(mids.item(i), XPathConstants.NUMBER);
                sum += mid;
                if(mid < min) min = mid;
                if(mid > max) max = mid;
            }
            long t3 = System.nanoTime();
            Runtime runtime = Runtime.getRuntime();

            System.out.printf("Czas łączny        : %.6f s%n", (t3-t1) * 1e-9);
            System.out.printf("Zajęta pamięć      : %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.gc();
            Thread.sleep(1000);
            System.out.printf("Zajęta pamięć po gc: %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.out.println("Count: " + count);
            if(count > 0) {
                System.out.println("Sum: " + sum);
                System.out.println("Avg: " + (sum / count));
                System.out.println("Min: " + min);
                System.out.println("Max: " + max);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
