package gotowe.p48_xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import java.io.File;

public class Waluty2_XPath {
    // Wersja w swojej strukturze podobna do Waluty1_Dom, ale zamiast getElementsByTagName będziemy tu używać wyrażeń XPath

    public static void main(String[] args) {
        File plik = new File("pliki/waluty2023.xml");
        String waluta = "EUR";

        System.out.println("Startujemy");
        long t1 = System.nanoTime();
        try {
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();

            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(plik);
            long t2 = System.nanoTime();

            double min = Double.MAX_VALUE, max = 0, sum = 0;
            int count = 0;

            NodeList tables = (NodeList) xpath.evaluate("//ExchangeRatesTable", doc, XPathConstants.NODESET);
            final int n = tables.getLength();
            for(int i = 0; i < n; i++) {
                Node table = tables.item(i);
                String effectiveDate = xpath.evaluate("EffectiveDate", table);
                // System.out.println(effectiveDate);
                NodeList rates = (NodeList) xpath.evaluate("Rates/Rate[Code='" + waluta + "']", table, XPathConstants.NODESET);
                final int m = rates.getLength();
                for(int j = 0; j < m; j++) {
                    Node rate = rates.item(j);
                    double mid = (Double) xpath.evaluate("Mid", rate, XPathConstants.NUMBER);
                    count++;
                    sum += mid;
                    if(mid < min) min = mid;
                    if(mid > max) max = mid;
                }
            }
            long t3 = System.nanoTime();
            Runtime runtime = Runtime.getRuntime();

            System.out.printf("Czas czytania pliku: %.6f s%n", (t2-t1) * 1e-9);
            System.out.printf("Czas liczenia      : %.6f s%n", (t3-t2) * 1e-9);
            System.out.printf("Czas łączny        : %.6f s%n", (t3-t1) * 1e-9);
            System.out.printf("Zajęta pamięć      : %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.gc();
            Thread.sleep(1000);
            System.out.printf("Zajęta pamięć po gc: %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.out.println("Count: " + count);
            if(count > 0) {
                System.out.println("Sum: " + sum);
                System.out.println("Avg: " + (sum / count));
                System.out.println("Min: " + min);
                System.out.println("Max: " + max);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
