package gotowe.p48_xml;

import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import java.io.File;

public class Walidacja {

    public static void main(String[] args) {
        try {
            SchemaFactory sf = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
            Schema schema = sf.newSchema(new File("pliki/sklep.xsd"));

            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setSchema(schema);
            // gdybyśmy nie podali error handlera, to warning oraz error wypisuje teksty na stderr
            // a fatalError przerywa program; przy czym typowe błędy walidacji są zgłaszane jako 'error'
            // my jednak użyjemy własnego error handlera:
            MojErrorHandler errorHandler = new MojErrorHandler();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            builder.setErrorHandler(errorHandler);
            Document doc = builder.parse("pliki/sklep.xml");
            System.out.println("Dokument wczytany " + doc);

            if(errorHandler.bylyBledy()) {
                System.out.println("Było " + errorHandler.getLicznikBledow() + " błędów");
            }

            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            String nazwa = xpath.evaluate("//towar[3]/nazwa", doc);
            System.out.println("Nazwa towaru: " + nazwa);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class MojErrorHandler implements ErrorHandler {
        private int licznikBledow = 0;

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.err.println(exception.getMessage());
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            licznikBledow++;
            System.err.println(exception.getMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.err.println(exception.getMessage());
            throw exception;
        }

        public int getLicznikBledow() {
            return licznikBledow;
        }

        public boolean bylyBledy() {
            return licznikBledow > 0;
        }
    }

}
