package gotowe.p48_xml;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.File;

public class Transformacja2 {
    public static void main(String[] args) {
        File plik = new File("pliki/sklep.xml");
        File xsl = new File("pliki/sklep_filtr.xsl");
        File out = new File("out/sklep_przefiltrowany.xml");

        System.out.println("Startujemy");
        try {
            long t1 = System.nanoTime();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer(new StreamSource(xsl));
            transformer.setParameter("kategoria", "herbata");
            transformer.transform(new StreamSource(plik), new StreamResult(out));

            System.out.println("Gotowe");

            long t3 = System.nanoTime();
            Runtime runtime = Runtime.getRuntime();

            System.out.printf("Czas łączny        : %.6f s%n", (t3-t1) * 1e-9);
            System.out.printf("Zajęta pamięć      : %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.gc();
            Thread.sleep(1000);
            System.out.printf("Zajęta pamięć po gc: %,d B%n", runtime.totalMemory() - runtime.freeMemory());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
