package gotowe.p48_xml;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.File;

public class Transformacja1 {
    public static void main(String[] args) {
        File plik = new File("pliki/sklep.xml");
        File xsl = new File("pliki/sklep_html.xsl");
        File out = new File("out/sklep.html");

        System.out.println("Startujemy");
        try {
            long t1 = System.nanoTime();
            TransformerFactory tf = TransformerFactory.newInstance();
            // domyślny transformer nie zmienia zawartości,
            // ale za jego pomocą można zmienić "wewn ętrzny format",
            // np. z drzewa DOM zrobić strumień SAX itp.
            // Transformer transformer = tf.newTransformer();

            // tutaj tworzymy Transformer na podstawie arkusza XSLT:
            // Platforma Java ma wbudowaną obsługę XSLT v 1.0,
            // Biblioteka Saxon pozwala obsłużyć także XSLT 2.0, 3.1, XQuery
            Transformer transformer = tf.newTransformer(new StreamSource(xsl));
            transformer.transform(new StreamSource(plik), new StreamResult(out));

            System.out.println("Gotowe");

            long t3 = System.nanoTime();
            Runtime runtime = Runtime.getRuntime();

            System.out.printf("Czas łączny        : %.6f s%n", (t3-t1) * 1e-9);
            System.out.printf("Zajęta pamięć      : %,d B%n", runtime.totalMemory() - runtime.freeMemory());
            System.gc();
            Thread.sleep(1000);
            System.out.printf("Zajęta pamięć po gc: %,d B%n", runtime.totalMemory() - runtime.freeMemory());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
