package gotowe.p32_spliterator;

import java.util.Spliterator;
import java.util.function.Consumer;

public class SpliteratorLiczbyNieparzyste implements Spliterator<Integer> {
	private int max;
	private int min;

	// domyślnie 100 liczb
	public SpliteratorLiczbyNieparzyste() {
		this(100);
	}
	public SpliteratorLiczbyNieparzyste(int ile) {
		this(0, ile);
	}

	private SpliteratorLiczbyNieparzyste(int min, int max) {
		this.min = min;
		this.max = max;
	}
	
	private int next() {
		return 1 + 2 * min++;
	}

	private boolean hasNext() {
		return min < max;
	}

	@Override
	public boolean tryAdvance(Consumer<? super Integer> action) {
		if(hasNext()) {
			action.accept(this.next());
			return true;
		} else {
			return false;
		}
	}

	@Override
	public SpliteratorLiczbyNieparzyste trySplit() {
		int middle = (max + min) / 2;
		
		SpliteratorLiczbyNieparzyste nowy = new SpliteratorLiczbyNieparzyste(min, middle);
		min = middle;
		return nowy;
	}

	@Override
	public long estimateSize() {
		return max - min;
	}

	@Override
	public int characteristics() {
		return ORDERED | DISTINCT | SIZED | SUBSIZED | NONNULL;
	}
	
}
