package gotowe.p30_lambdy.v3;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class EffectivelyFinal {
	private static int statyczna = 0;

	public static void main(String[] args) {
		
		// W wyrażeniach lambda (podobnie jak w klasach anonimowych) nie można używać zmiennych lokalnych, które są modyfikowane
		
		// Przykład kiedy to przeszkadza w praktyce:
		
		List<String> imiona = new ArrayList<>();
		imiona.add("Ala");
		imiona.add("Aleksandra");
		imiona.add("Ula");
		imiona.add("Elżbieta");
		
		double liczba = 0;
		
		liczba = liczba + imiona.size();
		
		// metoda forEach jest nowym sposobem iteracji po elementach list i innych kolekcji
		// wydaje się podobna do pętli for-each, ale jednak działa inaczej
//		for(String s: imiona) {
//			// ...
//		}

		int x = 0;
		int[] t = {0};
		AtomicInteger ai = new AtomicInteger();

		// Głupie rozwiązanie problemu "ile jest jest imion 3-literowych"
		imiona.forEach(s -> {
			if(s.length() == 3) {			
				// x++; // wewnątrz wyrażeń lambda nie można modyfikować zmiennych lokalnych z otoczenia

				// ani nawet używać zmiennych modyfikowanych poza lambdą
				//NK System.out.println(liczba);
				
				// mamy dostęp do zmiennych z poziomu klasy (statycznych, isntancyjnych)
				statyczna++;
				t[0]++;
				ai.incrementAndGet();
				// ale to zły styl
				// System.out.println(x);
			}
		});
		
		System.out.println("        x : " + x);
		System.out.println("statyczna : " + statyczna);
		System.out.println("        t : " + t[0]);
		System.out.println("AtomicInt : " + ai);

		// ale najlepiej:
		long count = imiona.stream().filter(s -> s.length() == 3).count();
		System.out.println("count: " + count);
	}
}
