package gotowe.p29_refleksja.sklep_model;

import java.lang.reflect.Field;

// Przykład uniwersalnej implementacji toString, która wypisuje wszystkie dostępne pola obiektu.
abstract class WspolnaNadklasa {
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        Class<? extends WspolnaNadklasa> klasa = this.getClass();
        result.append(klasa.getSimpleName()).append(" [");
        int fieldNo = 0;

        for(Field field: klasa.getDeclaredFields())
            try {
                if(fieldNo++ > 0) {
                    result.append(", ");
                }
                Object value;
                if(field.trySetAccessible()) {
                    value = field.get(this);
                } else {
                    value = "!";
                }
                result.append(field.getName()).append('=').append(value);
            } catch(IllegalArgumentException | IllegalAccessException e) {
                System.err.println(e);
            }
        result.append("]");

        return result.toString();
    }

}
