package gotowe.p13_abstrakcyjne;

import java.util.Locale;

public abstract class Figura {
    private String kolor;

    protected Figura(String kolor) {
        this.kolor = kolor;
    }

    public abstract double pole();

    public abstract double obwod();

    public String getKolor() {
        return kolor;
    }

    /* Dodatkowa rzecz, którą dopisałem po zajęciach.
     * Przy okazji:
     * 1) To jest przykład zastosowania wzroca "template method", który polega na tym,
     *    że w klasie abstrakcyjnej definiuje się metodę M, w której treści wywoływana
     *    jest metoda abstrakcyjna A. Podklasy tej klasy anstrakcyjnej definiują brakującą metodę A.
     *    W nadklasie zdefiniowane jest jakieś działanie na poziomie ogólnym,
     *    a podklasy uzupełniają szczegóły w odpowiedni dla siebie sposób.
     * 2) Od Java 17 istnieją Stringi blokowe, które zapisuje się w potrójnych cudzysłowach.
     *    Poziom wcięcia "zero" jest określany poprzez cudzysłowy zamykające.
     */
    public void wypiszInfo() {
        System.out.printf(Locale.US, """
                To jest figura klasy %s, jej kolor jest %s.
                Pole wynosi %s cm², a obwód %s cm.
                """, this.getClass().getSimpleName(), this.getKolor(),
                this.pole(), this.obwod());
    }
}
