package gotowe.p06_funkcje.przyklady;

// Specjalne komentarze pisane /** Opis */  tworzą dokumentację nazywaną "javadoc".
// W Eclipse można je wprowadzać skrótem Alt+Shift+J

/**
 * @author patryk
 * 
 * Klasa narzędziowa zawierająca metody statyczne służące do obliczania pól i obwodów figur geometrycznych.
 * 
 * To jest przykład klasy, w której nie ma metody main, tylko są zdefiniowane inne metody.
 */
public class Geometria {
    static {
        // Blok inicjalizacyjny statyczny to jest taki fragment kodu, który wykonuje się w momencie ładowania klasy do pamięci.
        System.out.println("ładowana jest klasa Geometria");
    }

    /** Oblicza pole kwadratu o podanym boku.
     * 
     * @param a długość boku
     * @return obliczone pole kwadratu
     */
    public static double poleKwadratu(double a) {
        return a * a;
    }

    /** Oblicza obwód kwadratu o podanym boku.
     * 
     * @param a długość boku
     * @return obliczony obwód kwadratu
     */
    public static double obwodKwadratu(double a) {
        return 4 * a;
    }

    /** Oblicza pole prostokąta o podanych bokach.
     * 
     * @param a długość pierwszego boku
     * @param b długość drugiego boku
     * @return obliczone pole prostokąta
     */
    public static double poleProstokata(double a, double b) {
        return a * b;
    }

    /** Oblicza obwód prostokąta o podanych bokach.
     * 
     * @param a długość pierwszego boku
     * @param b długość drugiego boku
     * @return obliczony obwód prostokąta
     */
    public static double obwodProstokata(double a, double b) {
        return 2 * a + 2 * b;
    }

    /** Oblicza pole koła o podanym promieniu.
     * 
     * @param r promień koła
     * @return obliczone pole koła
     */
    public static double poleKola(double r) {
        return Math.PI * r * r;
    }

    /** Oblicza obwód koła (aka długość okręgu) o podanym promieniu.
     * 
     * @param r promień koła
     * @return obliczony obwód koła
     */
    public static double obwodKola(double r) {
        return Math.PI * 2 * r;
    }

    /** Sprawdza czy z boków o podanych długościach da się ułożyć trójkąt.
     * 
     * @param a długość pierwszego boku
     * @param b długość drugiego boku
     * @param c długość trzeciego boku
     * @return <code>true</code> jeśli podane boki spełniają <dfn>warunek trójkąta</dfn>, <code>false</code> w przeciwnym przypadku
     */
    static boolean poprawnyTrojkat(double a, double b, double c) {
         return a > 0 && b > 0 && c > 0 && a < b+c && b < a+c && c < a+b;
     }

     /** Oblicza pole trójkąta na podstawie długości boków.
      * 
      * @param a długość pierwszego boku
      * @param b długość drugiego boku
      * @param c długość trzeciego boku
      * @return obliczone pole trójkąta
      * @throws IllegalArgumentException w przypadku, gdy z podanych boków nie da się ułożyć trójkąta
      */
     public static double poleTrojkata(double a, double b, double c) {
         if(!poprawnyTrojkat(a, b, c)) {
             throw new IllegalArgumentException("Boki nie pasują, nie da się złożyć trójkąta.");
         }
         double p = (a + b + c) / 2.;
         return Math.sqrt(p * (p - a) * (p - b) * (p - c));
     }

     /** Oblicza obwód trójkąta na podstawie długości boków.
      * 
      * @param a długość pierwszego boku
      * @param b długość drugiego boku
      * @param c długość trzeciego boku
      * @return obliczony obwód trójkąta
      */
     public static double obwodTrojkata(double a, double b, double c) {
         return a + b + c;
     }

}
