package gotowe.p06_funkcje.importowanie;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/* To jest fejkowa wersja listy, którą tworzę, aby w programach Imporcik1 i Imporcik2
 * pokazać, która klasa jest używana przez kompilator w zależności od sytuacji.
 */
public class List<T> {
    private final Object[] tablica;
    
    private List(T[] elems) {
        tablica = Arrays.copyOf(elems, elems.length);
    }
    
    public static <T> List<T> of(T... elems) {
        return new List<>(elems);
    }

    @Override
    public String toString() {
        return Stream.of(tablica)
                .map(Object::toString)
                .collect(Collectors.joining(", ", "ListaPatryka{", "}"));
    }
    
    public T get(int i) {
        if(i < 0 || i >= tablica.length) {
            throw new IndexOutOfBoundsException(i);
        }
        return (T)tablica[i];
    }
    
}
