package gotowe.p03_instrukcje.c_switch;

import javax.swing.JOptionPane;

public class DniTygodnia5 {
    // Od Java 14 istnieje też konstrukcja "switch expression".
    // Taki switch "daje wynik", który możemy np. wpisać do zmiennej.
    // Przypomina to wywołanie funkcji, ale nie jest to oddzielna funkcja, tylko wyrażneie wpisane w miejscu użycia.
    
    public static void main(String[] args) {
        try {
            int numer = Integer.parseInt(JOptionPane.showInputDialog("Podaj numer dnia tygodnia"));
            
            String nazwa = switch(numer) {
                case 1 -> "poniedziałek";
                case 2 -> "wtorek";
                case 3 -> "środa";
                case 4 -> "czwartek";
                case 5 -> "piątek";
                case 6 -> "sobota";
                case 7 -> "niedziela";
                default-> throw new IllegalArgumentException("Niepoprawny numer " + numer);
            };
            JOptionPane.showMessageDialog(null, "To jest " + nazwa);
        } catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Błąd", JOptionPane.ERROR_MESSAGE);            
        }
    }

}
