package gotowe.p02_zmienne;

import java.time.LocalTime;

public class SlowoVar {

    public static void main(String[] args) {
        // Przykład kompiluje się od Javy 10.

        // Deklaracja zmiennej lokalnej bez podawania typu.
        // Kompilator domyśla się typu na podstawie tego, co wpisujemy
        var y = 100;
        System.out.println(y);
        y = 101; // OK
        System.out.println(y);

        // Zmienna ma jednak typ int i nie wolno wpisać wartości niezgodnego typu
        // y = 3.14; // źle
        // y = "Ala ma kota"; // źle
        // System.out.println(y);

        // var n = null;

        // Konstrukcja dostępna tylka dla zmiennych lokalnych, gdy początkową wartość wpisuje się od razu w miejscu deklaracji.
        // var z;

        // var nie jest słowem kluczowym i w niekolidujących miejscach można go używać jako nazwy:
        String var = "tajemnicza zmienna";
        System.out.println(var);

        // BTW, odpowiednikiem takich zmiennych jak w Pythonie i PHP, na które można wpisać "wszystko",
        // w Javie jest raczej zmienna typu Object.

        Object o;
        o = "Ala ma kota";
        System.out.println(o.getClass().getSimpleName() + " : " + o);

        o = 100 + 15;
        System.out.println(o.getClass().getSimpleName() + " : " + o);

        o = LocalTime.now();
        System.out.println(o.getClass().getSimpleName() + " : " + o);
    }

}
