package emps;

import java.util.Comparator;
import java.util.stream.Stream;

public class S2_Filtrowanie {
    public static void main(String[] args) {
        try(Stream<Employee> empStream = ObslugaCSV.wczytajStrumieniowo()) {
            empStream
                    .filter(emp -> emp.getSalary() <= 5000)
                    .sorted(Comparator.comparing(Employee::getSalary))
                    .map(emp -> emp.getFirstName() + " " + emp.getLastName() + " z pensją " + emp.getSalary())
                    .map(String::toUpperCase)
                    .forEach(System.out::println);
        }
    }

}
