package emps;

import java.util.Comparator;
import java.util.List;

// P7 - wypisz pracowników posortowanych wg pensji malejąco
public class P7_Sortowanie {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");

		// takie sortowanie zadziałałoby tylko, gdyby klasa Employee implementowała Comparable
//		emps.sort(null);

		// Podejście do definiowania Comparatora oraz do samego sortowania sprzed Java 8
		// "klasa anonimowa"
//		Comparator<Employee> c = new Comparator<Employee>() {
//            public int compare(Employee emp1, Employee emp2) {
//                return emp2.getSalary() - emp1.getSalary();
//            }
//      };
//		Collections.sort(emps, c);

		// tutaj comparator zdefiniuję za pomocą wyrażenia lambda.
//		emps.sort((emp1, emp2) -> emp2.getSalary() - emp1.getSalary());

		// metoda compare z klas Integer, Long, Float, Double jest bardziej ogólnym sposobem porównania
		// niż odejmowanie - jest odporna na integer overflow oraz działa dla liczb z ułamkiem
//		emps.sort((emp1, emp2) -> -Integer.compare(emp1.getSalary(), emp2.getSalary()));

		// można też napisać to bardziej wprost:
		// posortuj obiekty Employee ze względu na ich pensję. odwrotnie
		emps.sort(Comparator.comparingInt(Employee::getSalary).reversed());

		for(Employee emp : emps) {
		    System.out.printf(" * %s %s (%s) z pensją %s%n",
                    emp.getFirstName(), emp.getLastName(), emp.getJobTitle(), emp.getSalary());
		}
		System.out.println();

		System.out.println("Najbiednieszy: " + emps.getFirst());
		System.out.println("Najbogatszy: " + emps.getLast());
	}

}

