package emps;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Grupowanie7 {
    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytaj();
        // groupingBy zwraca słownik, w którym dla każdej wartości kryterium znajduje się lista wszystkich obiektów należących do tej grupy
        Map<String, List<Employee>> grupy = emps.stream().collect(Collectors.groupingBy(Employee::getJobTitle));

        grupy.forEach((job, lista) -> {
            System.out.println(job);
            lista.forEach(emp -> System.out.println("    * " + emp.getFirstName() + " " + emp.getLastName()));
            System.out.println();
        });
    }
}
