package emps;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Grupowanie4a {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();

		// można też koncepcji mergowania użyć za pośrednictwem collectora "toMap"
		Map<String, Integer> sumy = emps.stream()
				.collect(Collectors.toMap(Employee::getJobTitle, Employee::getSalary, Integer::sum));
		Map<String, Integer> ilosci = emps.stream()
				.collect(Collectors.toMap(Employee::getJobTitle, emp -> 1, Integer::sum));

		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ile = ilosci.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |%n", job, ile, srednia);
		}
	}

}
