package emps;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Dla każdego jobTitle obliczamy średnią pensję
public class Grupowanie1a {
    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytaj();
        Map<String, Integer> ilosci = new HashMap<>();
        Map<String, Integer> sumy = new HashMap<>();
        for(Employee emp : emps) {
            final String jobTitle = emp.getJobTitle();
            if(sumy.containsKey(jobTitle)) {
                ilosci.put(jobTitle, ilosci.get(jobTitle) +1);
                sumy.put(jobTitle, sumy.get(jobTitle) + emp.getSalary());
            } else {
                ilosci.put(jobTitle, 1);
                sumy.put(jobTitle, emp.getSalary());
            }
        }
        // System.out.println(sumy);

        for(String job : sumy.keySet()) {
            int ile = ilosci.get(job);
            int suma = sumy.get(job);
            double srednia = (double)suma / ile;
            System.out.printf("%-32s | %2d | %8.2f\n", job, ile, srednia);
        }
    }
}
