package emps;

import javax.swing.*;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.stream.Collectors;

public class F4_SredniaJedenJob {
    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytaj();

        String szukanyJob = JOptionPane.showInputDialog("Podaj job", "Programmer");
        // w tej wersji w razie braku danych (czyli błędnie podanego joba)
        // średnia jest wyliczana jako 0
        double srednia = emps.stream()
                .filter(emp -> Objects.equals(emp.getJobTitle(), szukanyJob))
                .mapToInt(Employee::getSalary)
                .average()
                .orElse(0);
        System.out.println(srednia);

        // wersje, w których wynik zapisujemy do zmiennej "Optional" i sprawdzamy jak jest
        OptionalDouble avg = emps.stream()
                .filter(emp -> Objects.equals(emp.getJobTitle(), szukanyJob))
                .mapToInt(Employee::getSalary)
                .average();

        // zapis tradycyjny - if
        if(avg.isPresent()) {
            System.out.println("Średnia jest równa " + avg.getAsDouble());
        } else {
            System.out.println("Nikt nie ma takiego joba");
        }

        // zapisy "funkcyjne"
        // if bez else:
        avg.ifPresent(x -> System.out.println("Jest średnia " + x));

        // if z else:
        avg.ifPresentOrElse(x -> System.out.println("Taka średnia " + x),
                () -> System.out.println("Nie ma takiego kogoś"));
    }
}
