package emps;

import java.util.List;
import java.util.stream.Collectors;

public class F3_SredniaWszystkich {
    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytaj();

        double srednia1 = emps.stream()
                .mapToInt(Employee::getSalary)
                .average()
                .orElse(0);
        System.out.println(srednia1);

        // ewentalnie można też użyć gotowego "collectora"
        Double srednia2 = emps.stream()
                .collect(Collectors.averagingInt(Employee::getSalary));
        System.out.println(srednia2);
    }
}
