package emps;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class F2_Filtrowanie {
    // Program wypisuje tylko zarabiających >= 10 tys,
    // realizujemy to filtrowaniem, ale przy okazji pokazuję Wam schemat "filter / map" - podstawowe operacje na strumieniach.

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytaj();

        emps.stream()
            .filter(emp -> emp.getSalary() >= 10_000)
            .forEach(emp -> System.out.println(emp.getFirstName() + " " + emp.getLastName()));

        System.out.println("\n-----------------------\n");

        emps.stream()
            .filter(emp -> emp.getSalary() <= 5000)
            .sorted(Comparator.comparing(Employee::getSalary))
            .map(emp -> emp.getFirstName() + " " + emp.getLastName() + " z pensją " + emp.getSalary())
            .map(String::toUpperCase) // ew.  .map(s -> s.toUpperCase())
            .forEach(System.out::println);
        System.out.println("\n-----------------------\n");

        // Cały ten ↑ zapis jest określany "pipeline", który składa się z:
        // - źródła danych
        // - dowolnej liczby operacji pośrednich (intermediate, tutaj są to filter i map)
        // - operacji końcowej (terminal, tutaj jest to forEach)
        // Każdy obiekt przechodzi przez kolejne etapy przetwarzania, "schodzi z góry w dół".

        String wynik1 = emps.stream()
                .filter(F2_Filtrowanie::czyJestBogaty)
                .map(Employee::getLastName)
                .collect(Collectors.joining(", "));
        System.out.println(wynik1);

        String wynik2 = emps.stream()
                .filter(F2_Filtrowanie.sprawdzJob("Programmer"))
                .map(Employee::getLastName)
                .collect(Collectors.joining(", "));
        System.out.println(wynik2);
    }

    // tutaj sama ta metoda jest predykatem, dlatego w miejscu użycia
    // stosujemy method::reference
    private static boolean czyJestBogaty(Employee emp) {
        return emp.getSalary() >= 15_000;
    }

    // tutaj metoda ZWRACA w wyniku predykat,
    // dlatego w miejscu użycia w strumieniu trzeba ją wywołać() , aby uzyskać predykat
    private static Predicate<Employee> sprawdzJob(String expectedJob) {
        return emp -> emp.getJobTitle().equalsIgnoreCase(expectedJob);
    }

    private static Predicate<Employee> sprawdzJob2(String expectedJob) {
        return emp -> {
            String jobTitle = emp.getJobTitle();
            return jobTitle != null && jobTitle.equalsIgnoreCase(expectedJob);
        };
    }
}
