package com.example.demo.model;

import java.io.Serializable;

import jakarta.persistence.*;

/**
 * The persistent class for the countries database table.
 * 
 */
@Entity
@Table(name="countries")
@NamedQuery(name="Country.findAll", query="SELECT c FROM Country c")
public class Country implements Serializable {
    private static final long serialVersionUID = 1L;

    @Id
    @Column(name="country_id")
    private String countryId;

    @Column(name="country_name")
    private String countryName;

    //bi-directional many-to-one association to Region
    @ManyToOne
    @JoinColumn(name="region_id")
    private Region region;

    public Country() {
    }

    public String getCountryId() {
        return this.countryId;
    }

    public void setCountryId(String countryId) {
        this.countryId = countryId;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

}