package com.example.demo.data;

import java.util.List;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.example.demo.model.Employee;

@Repository
public class Repository3_Impl implements Repository3_Interface {
    @Autowired
    private EntityManager em;

    @Override
    public List<Employee> findAll() {
        TypedQuery<Employee> query = em.createNamedQuery("Employee.findAll", Employee.class);
        List<Employee> emps = query.getResultList();
        return emps;
    }
    
    @Override
    public Employee findOne(int employeeId) {
        return em.find(Employee.class, employeeId);
    }

    @Override
    public List<Employee> findByLastName(String lastName) {
        TypedQuery<Employee> query = em.createQuery(
                "SELECT emp FROM Employee emp WHERE emp.lastName = :name", Employee.class);
        query.setParameter("name", lastName);
        List<Employee> emps = query.getResultList();
        return emps;
    }
}
