package com.example.demo.data;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.example.demo.model.Department;
import com.example.demo.model.Employee;
import com.example.demo.model.Job;
import com.example.demo.model.Location;

/* Klasa pełniąca rolę repozytoium, czyli dostraczanie danych,
 * ale zaimplementowana bez bazy danych - po prostu zwraca przykładowe obiekty.
 */
@Repository
public class Repository0_Memory {
    
    public List<Employee> findAll() {
        Employee emp = exampleEmployee1();
        return List.of(emp);
    }

    private Employee exampleEmployee1() {
        Employee emp = new Employee();
        emp.setFirstName("Jan");
        emp.setLastName("Kowalski");
        emp.setSalary(BigDecimal.valueOf(12345));
        emp.setJob(exampleJob());
        emp.setDepartment(exampleDepartment());
        return emp;
    }

    private Department exampleDepartment() {
        Location loc = new Location();
        loc.setCity("Warszawa");
        
        Department dep = new Department();
        dep.setDepartmentName("Szkolenia");
        dep.setLocation(loc);
        return dep;
    }
    
    private Job exampleJob() {
        Job job = new Job();
        job.setJobTitle("Trainer");
        return job;
    }

}
