package sklep.security;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
public class SecurityConfig {
    @Bean
    SecurityFilterChain setHttpSecurity(HttpSecurity httpSecurity) throws Exception {
        httpSecurity
            .authorizeHttpRequests((authz) -> authz
                    .requestMatchers(HttpMethod.GET).permitAll()
                    .requestMatchers(HttpMethod.POST).hasRole("manager")
                    .requestMatchers(HttpMethod.PUT).hasRole("manager")
                    .requestMatchers(HttpMethod.DELETE).hasRole("manager")
                )
            .httpBasic(Customizer.withDefaults())
            .csrf(config -> config.disable());
        return httpSecurity.build();
    }
    
    @Bean
    InMemoryUserDetailsManager userDetailsService() {
        UserDetails[] users = {
                User.withUsername("ala").password("{noop}ala123").roles("manager", "worker").build(),
                User.withUsername("ola").password("{noop}ola123").roles("worker").build(),
        };
        return new InMemoryUserDetailsManager(users);
    }
}
