package sklep.rest;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.web.bind.annotation.PutMapping;
import sklep.model.Product;
import sklep.repository.ProductRepository;

import java.net.URI;
import java.util.List;

@Path("/products")
@Produces({"application/json"})
@Consumes({"application/json"})
public class RProducts {
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    private PhotoUtil photoUtil;

    @GET
    public List<Product> getProducts() {
        return productRepository.findAll();
    }

    @GET
    @Path("{id}")
    public Product getProduct(@PathParam("id") int id) {
        return productRepository.findById(id).orElseThrow(() -> new WebApplicationException(404));
    }

    @PUT
    @Path("/{id}")
    public void update(@PathParam("id") Integer productId, Product product) {
        product.setId(productId);
        productRepository.save(product);
    }

    @POST
    public Response insert(Product product) {
        // Aby mieć pewność, że zapytanie tworzy nowy rekord, ustawiam productId na null.
        product.setId(null);
        productRepository.save(product);
        URI uri = UriBuilder.fromResource(RProducts.class).path("{id}").build(product.getId());
        return Response.created(uri).build();
        // odpowiedź zgodnie z zasadami HTTP informuje o tym, że powstał nowy rekord pod podanym adresem
    }

    @DELETE
    @Path("/{id}")
    public void delete(@PathParam("id") Integer productId) {
        try {
            productRepository.deleteById(productId);
        } catch (EmptyResultDataAccessException e) {
            throw new WebApplicationException(e, 404);
        }
    }

    @GET
    @Path("/{id}/photo")
    @Produces("image/jpeg")
    public byte[] getPhoto(@PathParam("id") int productId) {
        return photoUtil.readBytes(productId);
    }

    @PUT
    @Path("/{id}/photo")
    @Consumes("image/jpeg")
    public void uploadPhoto(@PathParam("id") int productId, byte[] bytes) {
        photoUtil.writeBytes(productId, bytes);
    }
}
