package sklep.rest;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

@Path("/now")
// @Singleton
public class DataCzas {
    // W JAX-RS domyślne zachowanie jest takie, że dla każdego requestu tworzony jest nowy obiekt klasy obsługującej zapytania.
    // (polityka "per request"; można ją zmienić za pomocą adnotacji @Singleton - wtedy jeden obiekt obsłuży wszystkie zapytania)
    // Daje to możliwość zapisania pewnych ulotnych informacji w polach prywatnych tej klasy - nikt nam ich nie nadpisze.
    private LocalDateTime now = LocalDateTime.now();

    {
        // ten blok wykona się podczas tworzenia każdego obiektu
        System.out.println("Powstał obiekt DataCzas z czasem równym " + now);
    }

    // ta metoda obsługuje adres .../api/now
    @GET
    public LocalDateTime odczytajDataICzas() {
        return now;
    }

    // ta metoda obsługuje adres .../api/now/date
    @GET
    @Path("/date")
    public LocalDate odczytajDate() {
        return now.toLocalDate();
    }

    // ta metoda obsługuje adres .../api/now/date/year
    @GET
    @Path("/date/year")
    public int odczytajRok() {
        return now.getYear();
    }

    // ta metoda obsługuje adres .../api/now/date/month
    @GET
    @Path("/date/month")
    public int odczytajMiesiac() {
        return now.getMonthValue();
    }

    // ta metoda obsługuje adres .../api/now/date/day
    @GET
    @Path("/date/day")
    public int odczytajDzien() {
        return now.getDayOfMonth();
    }

    // ta metoda obsługuje adres .../api/now/time
    @GET
    @Path("/time")
    public LocalTime odczytajCzas() {
        return now.toLocalTime();
    }

    // ta metoda obsługuje adres .../api/now/time/second
    @GET
    @Path("/time/second")
    public int odczytajSekunde() {
        return now.getSecond();
    }

}
